// Copyright 2007. Adobe Systems Incorporated. All Rights Reserved.
package fl.controls {
	
	/**
	 * The orientation of the Slider component.
	 *
     * @see Slider#direction Slider.direction
     *
     * @langversion 3.0
     * @playerversion Flash 9.0.28.0
	 *  
	 *  @playerversion AIR 1.0

	 *  @productversion Flash CS3
	 */
	public class SliderDirection {
		/**
         * Position the Slider component on the horizontal axis.
         *
         * @includeExample examples/SliderDirection.HORIZONTAL.1.as -noswf
         *
         * @langversion 3.0
         * @playerversion Flash 9.0.28.0
		 *  
		 *  @playerversion AIR 1.0

		 *  @productversion Flash CS3
		 */
		public static var HORIZONTAL:String = 'horizontal';

		/**
         * Position the Slider component on the vertical axis.
         *
         * @includeExample examples/SliderDirection.VERTICAL.1.as -noswf
         *
         * @langversion 3.0
         * @playerversion Flash 9.0.28.0
		 *  
		 *  @playerversion AIR 1.0

		 *  @productversion Flash CS3
		 */
		public static var VERTICAL:String = 'vertical';
	}
	
}